<?php
header('Content-Type: application/json; charset=utf-8');

$action = isset($_GET['action']) ? $_GET['action'] : 'list';
$dataDir = __DIR__ . '/data';
if (!is_dir($dataDir)) {
    @mkdir($dataDir, 0777, true);
}
$playersFile = $dataDir . '/players.json';
$chatFile    = $dataDir . '/chat.json';
if (!file_exists($playersFile)) file_put_contents($playersFile, json_encode(new stdClass(), JSON_PRETTY_PRINT));
if (!file_exists($chatFile))    file_put_contents($chatFile, json_encode([], JSON_PRETTY_PRINT));

function load_json_arr($file, $default) {
    $json = @file_get_contents($file);
    if (!$json) return $default;
    $d = json_decode($json, true);
    return is_array($d) ? $d : $default;
}
function save_json($file, $data) {
    @file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

$players = load_json_arr($playersFile, []);
$now = time();
// Eski oyuncuları temizle
foreach ($players as $id => $p) {
    if (!isset($p['last_seen'])) continue;
    if ($now - (int)$p['last_seen'] > 20) unset($players[$id]);
}

if ($action === 'update') {
    $id = isset($_POST['id']) ? $_POST['id'] : null;
    if (!$id) { echo json_encode(['ok'=>false,'error'=>'id yok']); exit; }
    $name  = substr(trim($_POST['name'] ?? 'Oyuncu'), 0, 16);
    $color = substr(trim($_POST['color'] ?? '#22c55e'), 0, 16);
    $x     = floatval($_POST['x'] ?? 0);
    $y     = floatval($_POST['y'] ?? 0);
    $r     = floatval($_POST['r'] ?? 20);
    $score = floatval($_POST['score'] ?? 0);

    $players[$id] = [
        'id'=>$id,'name'=>$name,'color'=>$color,
        'x'=>$x,'y'=>$y,'r'=>$r,'score'=>$score,
        'last_seen'=>$now
    ];
    save_json($playersFile, $players);
    echo json_encode(['ok'=>true]); exit;
}

if ($action === 'list') {
    echo json_encode(['ok'=>true,'players'=>array_values($players)]); exit;
}

if ($action === 'chat_send') {
    $name = substr(trim($_POST['name'] ?? 'Oyuncu'), 0, 16);
    $text = trim($_POST['text'] ?? '');
    if ($text===''){ echo json_encode(['ok'=>false,'error'=>'bos mesaj']); exit; }

    $messages = load_json_arr($chatFile, []);
    $lastId = 0;
    if (!empty($messages)) {
        $last = end($messages);
        $lastId = intval($last['id'] ?? 0);
    }
    $id = $lastId + 1;
    $timeStr = date('H:i', $now);
    $messages[] = ['id'=>$id,'name'=>$name,'text'=>$text,'time'=>$timeStr];
    if (count($messages) > 50) $messages = array_slice($messages, -50);
    save_json($chatFile, $messages);
    echo json_encode(['ok'=>true]); exit;
}

if ($action === 'chat_list') {
    $since = intval($_GET['since'] ?? 0);
    $messages = load_json_arr($chatFile, []);
    $out = [];
    foreach ($messages as $m) {
        if (intval($m['id'] ?? 0) > $since) $out[] = $m;
    }
    echo json_encode(['ok'=>true,'messages'=>$out]); exit;
}

echo json_encode(['ok'=>false,'error'=>'gecersiz action']);
